(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     31016,        676]
NotebookOptionsPosition[     30679,        659]
NotebookOutlinePosition[     31036,        675]
CellTagsIndexPosition[     30993,        672]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "NMR", " ", "Spectrum", " ", "without", " ", "Noise", " ", "component"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", "\[IndentingNewLine]", "\t  ", 
     RowBox[{
     "This", " ", "test", " ", "is", " ", "somehow", " ", "chanllenging", " ",
       "for", " ", "the", " ", 
      RowBox[{"computer", ".", "\[IndentingNewLine]", "\t", "Please"}], " ", 
      "be", " ", "patient", " ", "when", " ", "you", " ", "change", " ", 
      "the", " ", "paratmeter", " ", "in", " ", "the", " ", "control", " ", 
      RowBox[{"panel", ".", "\[IndentingNewLine]", "\t", "Especially"}], " ", 
      "when", " ", "you", " ", "set", " ", "a", " ", "high", " ", "value", 
      " ", "for", " ", "transients"}]}], ",", " ", 
    RowBox[{
    "the", " ", "program", " ", "will", " ", "last", " ", "long", " ", "with",
      " ", "every", " ", "changes", " ", "of", " ", "other", " ", 
     "parameters"}]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "\"\<`Global*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{"t0", "/", "n"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<Free Induction Decay\>\"", ",", "\"\<Label\>\"", ",", "15", 
            ",", "Red", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"2", "*", "Pi", "*", "d", "*", "t"}], "+", 
               "\[CurlyPhi]"}], "]"}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"t", "-", "b"}], ")"}], "2"]}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "lb"}], "*", "t"}], "]"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A1", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T1"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w1", "*", "t"}], "]"}]}], "+", 
               
               RowBox[{"A2", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T2"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w2", "*", "t"}], "]"}]}], "+", 
               
               RowBox[{"A3", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T3"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w3", "*", "t"}], "]"}]}]}], 
              ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "t0"}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}], 
            ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"400", ",", "200"}], "}"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<Frequency Spectrum\>\"", ",", "\"\<Label\>\"", ",", "15", ",",
             "Red", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sum", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"2", "*", "Pi", "*", "d", "*", "k", "*", "t"}], "+",
                   "\[CurlyPhi]"}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A1",
                 "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                  RowBox[{"(", 
                   RowBox[{"w1", "-", "w"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "k"}], "*", 
                  RowBox[{"t", "/", "T1"}]}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", 
                 RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "+", 
             RowBox[{"Sum", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"d", "*", "k", "*", "t"}], "+", "\[CurlyPhi]"}], 
                 "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A2",
                 "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                  RowBox[{"(", 
                   RowBox[{"w2", "-", "w"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "k"}], "*", 
                  RowBox[{"t", "/", "T2"}]}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", 
                 RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "+", 
             RowBox[{"Sum", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"d", "*", "k", "*", "t"}], "+", "\[CurlyPhi]"}], 
                 "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A3",
                 "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                  RowBox[{"(", 
                   RowBox[{"w3", "-", "w"}], ")"}]}], "]"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "k"}], "*", 
                  RowBox[{"t", "/", "T3"}]}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", 
                 RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"w", ",", 
              RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], "]"}]}], 
            ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "All"}], "}"}]}],
             ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"400", ",", "200"}], "}"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
        RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<NMR Signal and Spectrum\>\"", ",", "15", ",", "Blue", ",", 
       "Bold"}], "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "Delimiter", ",", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Parameters of Signal\>\"", ",", "15", ",", "Blue", ",", " ", 
       "Bold"}], "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t0", ",", "2", ",", "\"\<Acquition time\>\""}], "}"}], ",", 
       "0.01", ",", "5", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", "20", ",", "\"\<Number of data points\>\""}], "}"}],
        ",", "0", ",", "100", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A1", ",", "0.25", ",", "\"\<Amplitude of component I\>\""}], 
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A2", ",", "0.25", ",", "\"\<Amplitude of component II\>\""}],
         "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A3", ",", "0.25", ",", "\"\<Amplitude of component III\>\""}], "}"}],
        ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w1", ",", "1", ",", "\"\<Frequency of component I\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w2", ",", "0.2", ",", "\"\<Frequency of component II\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w3", ",", 
         RowBox[{"-", "1"}], ",", "\"\<Frequency of component III\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T1", ",", "2", ",", "\"\<T2 relaxation of component I\>\""}],
         "}"}], ",", "0", ",", "5", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "T2", ",", "2", ",", "\"\<T2 relaxation of component II\>\""}], "}"}],
        ",", "0", ",", "5", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "T3", ",", "2", ",", "\"\<T2 relaxation of component III\>\""}], 
        "}"}], ",", "0", ",", "5", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Window Functions\>\"", ",", "15", ",", "Blue", ",", " ", "Bold"}], 
      "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lb", ",", "0", ",", "\"\<Exponential Apodization\>\""}], 
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "c", ",", "10", ",", "\"\<Gausiian Apodization (Variance)\>\""}], 
        "}"}], ",", "0.1", ",", "10", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "0", ",", "\"\<Gaussian Variance (Shift)\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "10"}], ",", "10", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "0", ",", "\"\<Sine Function (Peoredical)\>\""}], 
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[CurlyPhi]", ",", "0", ",", "\"\<Sine Function (Shift)\>\""}], 
        "}"}], ",", "0", ",", "2", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Exponential", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Gaussian", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Sin", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"d", "*", "k", "*", "t"}], "+", "\[CurlyPhi]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.537294014311925*^9, 3.537294088998049*^9}, {
   3.5372942520008*^9, 3.537294260838106*^9}, {3.537740168547884*^9, 
   3.537740237358048*^9}, {3.5377403067645197`*^9, 3.537740322294119*^9}, {
   3.537740381698986*^9, 3.537740384498863*^9}, {3.537740452850943*^9, 
   3.537740555304151*^9}, 3.537740610656028*^9, {3.537740642326172*^9, 
   3.5377407146408854`*^9}, {3.537740761132018*^9, 3.537740763420062*^9}, {
   3.537740824866659*^9, 3.537740879873254*^9}, {3.537740937692464*^9, 
   3.5377410013931723`*^9}, {3.537741039297462*^9, 3.53774107001195*^9}, {
   3.5377411361472816`*^9, 3.5377411726503572`*^9}, {3.537741208715568*^9, 
   3.537741519328293*^9}, {3.537741663060265*^9, 3.537741689539298*^9}, {
   3.5377417327959557`*^9, 3.537741852550932*^9}, {3.537758898005846*^9, 
   3.5377589051977577`*^9}, 3.537758954959756*^9, {3.537759006193674*^9, 
   3.5377590127208652`*^9}, {3.537759122124563*^9, 3.53775913114649*^9}, {
   3.537759325798357*^9, 3.537759391394*^9}, {3.537759452864129*^9, 
   3.5377595463849916`*^9}, {3.53775961019077*^9, 3.537759614622725*^9}, {
   3.53775966868808*^9, 3.5377597078807173`*^9}, {3.537759768012887*^9, 
   3.537759811675497*^9}, {3.538024224914892*^9, 3.5380242259744673`*^9}, {
   3.538071761688493*^9, 3.538071802971195*^9}, {3.538073069351815*^9, 
   3.5380731979671097`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`A1$$ = 0.25, $CellContext`A2$$ = 
    0.25, $CellContext`A3$$ = 0.25, $CellContext`b$$ = 0, $CellContext`c$$ = 
    10, $CellContext`d$$ = 0, $CellContext`lb$$ = 0, $CellContext`n$$ = 
    20, $CellContext`t0$$ = 2, $CellContext`T1$$ = 2, $CellContext`T2$$ = 
    2, $CellContext`T3$$ = 2, $CellContext`w1$$ = 1, $CellContext`w2$$ = 
    0.2, $CellContext`w3$$ = -1, $CellContext`\[CurlyPhi]$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["NMR Signal and Spectrum", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Parameters of Signal", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`t0$$], 2, "Acquition time"}, 0.01, 5, 0.01}, {{
       Hold[$CellContext`n$$], 20, "Number of data points"}, 0, 100, 1}, {{
       Hold[$CellContext`A1$$], 0.25, "Amplitude of component I"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`A2$$], 0.25, "Amplitude of component II"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`A3$$], 0.25, "Amplitude of component III"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`w1$$], 1, "Frequency of component I"}, -2, 2, 0.1}, {{
       Hold[$CellContext`w2$$], 0.2, "Frequency of component II"}, -2, 2, 
      0.1}, {{
       Hold[$CellContext`w3$$], -1, "Frequency of component III"}, -2, 2, 
      0.1}, {{
       Hold[$CellContext`T1$$], 2, "T2 relaxation of component I"}, 0, 5, 
      0.1}, {{
       Hold[$CellContext`T2$$], 2, "T2 relaxation of component II"}, 0, 5, 
      0.1}, {{
       Hold[$CellContext`T3$$], 2, "T2 relaxation of component III"}, 0, 5, 
      0.1}, {
      Hold[
       Style["Window Functions", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`lb$$], 0, "Exponential Apodization"}, 0, 1, 0.01}, {{
      
       Hold[$CellContext`c$$], 10, "Gausiian Apodization (Variance)"}, 0.1, 
      10, 0.1}, {{
       Hold[$CellContext`b$$], 0, "Gaussian Variance (Shift)"}, -10, 10, 
      0.1}, {{
       Hold[$CellContext`d$$], 0, "Sine Function (Peoredical)"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`\[CurlyPhi]$$], 0, "Sine Function (Shift)"}, 0, 2, 
      0.01}}, Typeset`size$$ = {400., {229.84375, 235.15625}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`t0$19967$$ = 0, $CellContext`n$19968$$ = 
    0, $CellContext`A1$19969$$ = 0, $CellContext`A2$19970$$ = 
    0, $CellContext`A3$19971$$ = 0, $CellContext`w1$19972$$ = 
    0, $CellContext`w2$19973$$ = 0, $CellContext`w3$19974$$ = 
    0, $CellContext`T1$19975$$ = 0, $CellContext`T2$19976$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`A1$$ = 0.25, $CellContext`A2$$ = 
        0.25, $CellContext`A3$$ = 0.25, $CellContext`b$$ = 
        0, $CellContext`c$$ = 10, $CellContext`d$$ = 0, $CellContext`lb$$ = 
        0, $CellContext`n$$ = 20, $CellContext`t0$$ = 2, $CellContext`T1$$ = 
        2, $CellContext`T2$$ = 2, $CellContext`T3$$ = 2, $CellContext`w1$$ = 
        1, $CellContext`w2$$ = 
        0.2, $CellContext`w3$$ = -1, $CellContext`\[CurlyPhi]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t0$$, $CellContext`t0$19967$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$19968$$, 0], 
        Hold[$CellContext`A1$$, $CellContext`A1$19969$$, 0], 
        Hold[$CellContext`A2$$, $CellContext`A2$19970$$, 0], 
        Hold[$CellContext`A3$$, $CellContext`A3$19971$$, 0], 
        Hold[$CellContext`w1$$, $CellContext`w1$19972$$, 0], 
        Hold[$CellContext`w2$$, $CellContext`w2$19973$$, 0], 
        Hold[$CellContext`w3$$, $CellContext`w3$19974$$, 0], 
        Hold[$CellContext`T1$$, $CellContext`T1$19975$$, 0], 
        Hold[$CellContext`T2$$, $CellContext`T2$19976$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`t = $CellContext`t0$$/$CellContext`n$$; 
       Column[{
          Style["Free Induction Decay", "Label", 15, Red, Bold], 
          Plot[
          Cos[2 Pi $CellContext`d$$ $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
           Exp[(-($CellContext`t - $CellContext`b$$)^2)/(2 $CellContext`c$$)] 
           Exp[(-$CellContext`lb$$) $CellContext`t] ($CellContext`A1$$ 
             Exp[(-$CellContext`t)/$CellContext`T1$$] 
             Cos[2 Pi $CellContext`w1$$ $CellContext`t] + $CellContext`A2$$ 
             Exp[(-$CellContext`t)/$CellContext`T2$$] 
             Cos[2 Pi $CellContext`w2$$ $CellContext`t] + $CellContext`A3$$ 
             Exp[(-$CellContext`t)/$CellContext`T3$$] 
             Cos[2 Pi $CellContext`w3$$ $CellContext`t]), {$CellContext`t, 
            0, $CellContext`t0$$}, PlotRange -> {{0, $CellContext`t0$$}, All},
            Frame -> True, FrameLabel -> Style["t (s)", 16, Italic], 
           PlotStyle -> {Red, 
             AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
           0.35], 
          Style["Frequency Spectrum", "Label", 15, Red, Bold], 
          Plot[
          Sum[Cos[2 
                Pi $CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
             Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
               2 $CellContext`c$$)] 
             Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A1$$ 
             Cos[2 Pi $CellContext`t $CellContext`k ($CellContext`w1$$ - \
$CellContext`w)] 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T1$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}] + 
           Sum[Cos[$CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
             Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
               2 $CellContext`c$$)] 
             
             Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A2$$ 
             Cos[2 Pi $CellContext`t $CellContext`k ($CellContext`w2$$ - \
$CellContext`w)] 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T2$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}] + 
           Sum[Cos[$CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
             Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
               2 $CellContext`c$$)] 
             Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A3$$ 
             Cos[2 Pi $CellContext`t $CellContext`k ($CellContext`w3$$ - \
$CellContext`w)] 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T3$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}], {$CellContext`w, -2, 2}, Frame -> 
           True, FrameLabel -> Style["f (Hz)", 16, Italic], PlotStyle -> {Red, 
             AbsoluteThickness[2]}, PlotRange -> {{-2, 2}, All}, 
           ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> 
         Center, Spacings -> 1]), "Specifications" :> {
        Style["NMR Signal and Spectrum", 15, 
         RGBColor[0, 0, 1], Bold], Delimiter, 
        Style["Parameters of Signal", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`t0$$, 2, "Acquition time"}, 0.01, 5, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`n$$, 20, "Number of data points"}, 0, 100, 1, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A1$$, 0.25, "Amplitude of component I"}, 0, 1,
          0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A2$$, 0.25, "Amplitude of component II"}, 0, 
         1, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A3$$, 0.25, "Amplitude of component III"}, 0, 
         1, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w1$$, 1, "Frequency of component I"}, -2, 2, 
         0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w2$$, 0.2, "Frequency of component II"}, -2, 
         2, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w3$$, -1, "Frequency of component III"}, -2, 
         2, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T1$$, 2, "T2 relaxation of component I"}, 0, 
         5, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T2$$, 2, "T2 relaxation of component II"}, 0, 
         5, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T3$$, 2, "T2 relaxation of component III"}, 0,
          5, 0.1, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Window Functions", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`lb$$, 0, "Exponential Apodization"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`c$$, 10, "Gausiian Apodization (Variance)"}, 
         0.1, 10, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`b$$, 0, "Gaussian Variance (Shift)"}, -10, 10,
          0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`d$$, 0, "Sine Function (Peoredical)"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[CurlyPhi]$$, 0, "Sine Function (Shift)"}, 0,
          2, 0.01, Appearance -> "Labeled", ImageSize -> Small}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{740., {257., 262.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`t = 0.05505}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.53729425856262*^9, 3.537294261230113*^9}, 
   3.537740563597295*^9, 3.537740642977612*^9, {3.537740690172412*^9, 
   3.5377407167272453`*^9}, 3.537740826973569*^9, 3.537740882620577*^9, {
   3.537740956290544*^9, 3.5377410070023623`*^9}, {3.537741042762868*^9, 
   3.5377410716542377`*^9}, 3.537741168586062*^9, 3.537741311278728*^9, 
   3.537741792008379*^9, 3.537741853989723*^9, 3.5377589592692137`*^9, 
   3.5377590139629087`*^9, 3.5377591341340322`*^9, 3.537759329967395*^9, 
   3.537759393571096*^9, {3.537759454756962*^9, 3.5377594823098173`*^9}, {
   3.537759514196718*^9, 3.537759547749754*^9}, 3.537759615988302*^9, {
   3.5377596895426207`*^9, 3.537759717425562*^9}, {3.537759795266507*^9, 
   3.537759813409816*^9}, 3.53807180684484*^9, 3.538073119726156*^9, {
   3.5380731757127247`*^9, 3.5380732035654583`*^9}}]
}, Open  ]]
},
WindowSize->{1280, 679},
WindowMargins->{{12, Automatic}, {-27, Automatic}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 18917, 433, 1061, "Input"],
Cell[19499, 457, 11164, 199, 536, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
